;
;
;
;
;
;
;
;
;		"Watercolours" effect
;
;
;
;
;
;
;
;
;

messageon		equ	0
loadtex			equ	1

rgb			equ	1
flash			equ	0
vblwait			equ	1
keys			equ	1
tracker_on		equ	0

screenlines		equ	240
bytesperline		equ	384*2
lines			equ	240
pixels			equ	384

direction		equ	1		;(motion blur)







back_colour	equ	0
noscreens	equ	2
demo		equ	0



start:
		output	e:\watercol.prg

	ifne	demo
		include	f:\source\tdf\main\equates.s

		opt	nodebug
	endc


	ifeq	demo
		include equates.s
		include	tosstart.i
	else
		include	demstart.i
	endc


;--------------------------------------------------------------
preload:	rts

display_routine:
		bsr	do_effects
		illegal

initialize_routine:
		bsr	set_res
		bsr	calc_colour_table
		rts

do_effects:
		bsr	clearscreens


		;bsr	clearscreen
		move.w	#$1000,d0
		bsr	main_loop
		rts

main_loop:
		move.l	d0,-(a7)

		move.l	(a7)+,d0
repeat:
		move.w	#100,d0
		subq.w	#4,d0
.main_loop
		move.w	d0,-(a7)
		bsr	create_frame
		move.w	(a7)+,d0
		dbf	d0,.main_loop
		bra	repeat
		rts



create_frame:
		bsr	draw_smoke
		bsr	smoke_screen

		bsr	screen_swap
		rts

create_frame2:
		;bsr	draw_smoke
		bsr	smoke_screen

		bsr	screen_swap
		rts



clearscreen:
		move.l	#$0809,d0
		movec	d0,cacr

		move.l	logic,a3
		move.l	#(lines*pixels/4)-40,d7
		lea	back_colours(pc),a1
		lea	back_additions(pc),a2

		moveq	#0,d4			;current colour
.clear:
		bsr	get_random
		and.w	#%11,d0
		add.w	(a2,d0.w*2),d4
		and.w	#%1111,d4

		move.w	(a1,d4.w*2),d6		;get colour
		move.w	d6,d5
		swap	d6
		move.w	d5,d6
		bsr	get_random
		and.w	#%11111,d0
		addq.w	#4,d0
		ext.l	d0
		sub.l	d0,d7

		subq.w	#1,d0
.wipe:
		move.l	d6,(a0)+
		move.l	d6,(a3)+
		dbf	d0,.wipe
		tst.l	d7
		bpl.s	.clear

		move.l	#$1919,d0
		movec	d0,cacr
		rts
;--------------------------------------------------------------
;						get_random
get_random:	movem.w	random_seed,d0/d1/d2
		add.w	d1,d0
		add.w	#1,d0
		mulu.w	#259,d0
		mulu.w	#59,d1
		add.w	#17,d1
		mulu.w	#9,d2
		add.w	#7,d2
		movem.w	d0/d1/d2,random_seed
		swap	d0
		rts

;--------------------------------------------------------------
set_res:
;        MOVE.L   #$C6008D,$FFFF8282.W
;        MOVE.L   #$1502AC,$FFFF8286.W
;        MOVE.L   #$8D0096,$FFFF828A.W
;        MOVE.L   #$41903AF,$FFFF82A2.W
;        MOVE.L   #$8F008D,$FFFF82A6.W
;        MOVE.L   #$3AD0415,$FFFF82AA.W
;        MOVE.W   #$200,$FFFF820A.W
;        MOVE.W   #$186,$FFFF82C0.W
;        CLR.W    $FFFF8266.W
;        MOVE.W   #$100,$FFFF8266.W
;        MOVE.W   #$5,$FFFF82C2.W
;        MOVE.W   #$140,$FFFF8210.W
;
;		move.w	#(384-320),$ffff820e.w	;line width in words

		move.w	#$64,-(a7)
		move.w	#$3,-(a7)
		move.l	logic(pc),-(a7)
		move.l	logic(pc),-(a7)
		move.w	#5,-(a7)
		trap	#14
		lea	14(a7),a7

		ori.w	#1,$ffff82c2.w	
		clr.l	$ffff9800.w
		rts


;--------------------------------------------------------------
smoke_screen:
		move.l	#$0009,d0
		movec	d0,cacr

		bsr	update_smoke 

		move.l	smokes,a2
		move.l	logic(pc),a4

		lea	reduce_table,a5
		lea	smoke_colour_table,a6
		moveq	#0,d3
		moveq	#0,d4			;output byte

		move.w	#100-1,d0		;d0 = line count
.line:
		move.w	#192-1,d1		;d1 = pixel count

; ought to keep a running buffer for the blur!

.pixel:
		move.w	(a0)+,d3		;d2 = smoke offset
		move.w	(a2,d3.w*2),d3		;get old graphic
		add.w	2(a2,d3.w*2),d3		;get old graphic 2
		add.w	(a2),d3

		move.w	(a5,d3.w*2),d3		;reduce the value
		move.w	d3,(a2)+		;save in buffer2

		swap	d4
		move.w	(a6,d3.w*2),d4		;get colour
		move.l	d4,(a4)+		;draw it

		dbf	d1,.pixel
		;lea	(384-192)*2(a0),a0
		;lea	(384-192)*2(a4),a4

		dbf	d0,.line
		rts

update_smoke:
		lea	sine1(pc),a0
		bsr	update_sines
		lea	sine_table(pc),a2
		move.w	(a2,d0.w*2),d0
		move.w	(a2,d1.w*2),d1

		muls.w	#192,d0
		swap	d0
		add.w	#96,d0

		muls.w	#100,d1
		swap	d1
		add.w	#50,d1

		muls.w	#384*2,d1

		muls.w	#2,d0
		add.l	d0,d1
		;lea	(smoke_table,d1.l),a0
		lea	smoke_table,a0
		rts


draw_smoke:
o		set	0
		rept	8
		lea	sine_smoke+18*o(pc),a0 
		bsr	.draw_blob
o		set	o+1
		endr

;		move.w	#192/4,d0
;		move.w	#80,d1
;		bsr	.draw_blob2
;		move.w	#96,d0
;		move.w	#80,d1
;		bsr	.draw_blob2
;		move.w	#192*3/4,d0
;		move.w	#80,d1
;		bsr	.draw_blob2
		rts

.draw_blob:
		lea	sine_table(pc),a2
		bsr	update_sines
		move.w	(a2,d0.w*2),d6
		move.w	(a2,d1.w*2),d7
		bsr	update_sines
		move.w	(a2,d0.w*2),d4
		move.w	(a2,d1.w*2),d5
		asr	d4
		asr	d5
		asr	d6
		asr	d7
		add.w	d4,d6
		add.w	d5,d7
		move.w	d6,d0
		move.w	d7,d1

		muls.w	#192,d0
		swap	d0
		add.w	#192/2,d0

		muls.w	#46*2,d1
		swap	d1
		add.w	#46,d1

deb
.draw_blob2:
		muls.w	#192*2,d1
		muls.w	#2,d0
		add.l	d0,d1

; get the colour data:
		move.w	(a0),d2
		swap	d2
		move.w	(a0)+,d2

		move.l	smokes(pc),a0
		lea	(a0,d1.l),a0
		move.l	a0,a1 

		move.l	d2,d1
		add.l	d1,d1
		move.l	d1,d0
		add.l	d2,d0

		add.w	d2,(a0)+
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		add.w	d1,(a0)+
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		lea	192*2-14(a0),a0

		add.w	d2,(a0)+
		add.w	d1,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d1,(a0)+
		add.w	d2,(a0)+
		lea	192*2-14(a0),a0

		move.w	#3-1,d7
.draw
		add.w	d1,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d1,(a0)+
		lea	192*2-14(a0),a0
		dbf	d7,.draw

		add.w	d2,(a0)+
		add.w	d1,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d0,(a0)+
		add.w	d1,(a0)+
		add.w	d2,(a0)+
		lea	192*2-14(a0),a0
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		add.w	d1,(a0)+
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		add.w	d2,(a0)+
		lea	192*2-14(a0),a0
; Now blur them:
		rts


update_sines:
		movem.w	(a0)+,d2/d3

		move.w	(a0),d0
		add.w	d2,d0
		and.w	#$1fff,d0
		move.w	d0,(a0)+

		move.w	(a0),d1
		add.w	d3,d1
		and.w	#$1fff,d1
		move.w	d1,(a0)+
		rts



;--------------------------------------------------------------
calc_colour_table:
		rts

;--------------------------------------------------------------
			section	data

random_seed:		ds.w	3

sine1:			dc.w	44,-48,100,20
			dc.w	0,0

sine_smoke:
			dc.w	+150,+117,0,0
			dc.w	+118,-150,0,0
			dc.w	+12

			dc.w	+143,+20,0,0
			dc.w	+16,+153,0,0
			dc.w	-12

			dc.w	+45,+114,0,0
			dc.w	+132,-52,0,0
			dc.w	+12

			dc.w	+18,-50,0,0
			dc.w	+43,+20,0,0
			dc.w	-12

			dc.w	+150,+17,0,0
			dc.w	+118,-150,0,0
			dc.w	+12

			dc.w	+143,+20,0,0
			dc.w	+16,+53,0,0
			dc.w	-12

			dc.w	+45,-14,0,0
			dc.w	+132,-52,0,0
			dc.w	+12

			dc.w	-18,-130,0,0
			dc.w	23,+20,0,0
			dc.w	-12

	
back_colours
			trucol	0,0,0
			trucol	1,1,1
			trucol	2,2,2
			trucol	3,3,3
			trucol	4,4,4
			trucol	5,5,5
			trucol	6,6,6
			trucol	7,7,7
			trucol	8,8,8
			trucol	7,7,7
			trucol	6,6,6
			trucol	5,5,5
			trucol	4,4,4
			trucol	3,3,3
			trucol	2,2,2
			trucol	1,1,1


back_additions
			dc.w	-1,2,-2,+1

sine_table		incbin	d:\Data\TrailSin.Dat

smokes			dc.l	smoke_buffer_1,smoke_buffer_2

smoke_table		
			;incbin	d:\data\_Data\Smoke2.Dat
			incbin	d:\data\blurout.Dat
			even
	

;--------------------------------------------------------------
			dcb.w	256,-255

o			set	-255
			rept	255
			dc.w	o,o,o
o			set	o+1
			endr

			dcb.w	2,0
reduce_table:
			dcb.w	2,0

o			set	0
			rept	255
			dc.w	o,o,o
o			set	o+1
			endr
			dcb.w	256,255


;--------------------------------------------------------------

			incbin	d:\data\_data\water\water1.tru
smoke_colour_table:
o			set	31
			dc.w	-1

			rept	32
			trucol	o,o,31
			trucol	o,o,31
			trucol	o,o,31
			trucol	(o-1),o,31
			trucol	(o-1),o,31
			trucol	(o-1),(o-1),31
			trucol	(o-1),(o-1),31
			trucol	(o-1),(o-1),31
o			set	o-1
			endr

			rept	256
			trucol	(o-1),(o-1),o
			endr


;--------------------------------------------------------------


			section	bss

			ds.w	192*10
smoke_buffer_1		ds.w	192*100
			ds.w	192*10
smoke_buffer_2		ds.w	192*100
			ds.w	192*10


			ds.l	300
stack

